//
//  table_S_V_G_.h
//  GSFontTools
//
//  Created by Georg Seifert on 06/09/14.
//
//

#import <GSFontTools/TTable.h>

@interface OTDocumentIndexEntry : NSObject {
	NSString *_svgDoc;
  @public
	uint16_t _startGlyphID;
	uint16_t _endGlyphID;
	uint32_t _svgDocOffset;
	uint32_t _svgDocLength;
}

@property (strong, nonatomic) NSString *svgDoc;
@property (nonatomic) uint16_t startGlyphID;
@property (nonatomic) uint16_t endGlyphID;

- (BOOL)decompile:(NSData *)data offset:(NSUInteger *)pos;

@end

@interface OTColorPalettes : NSObject
@property (nonatomic, retain) NSMutableArray *colorParamUINameIDs;
@property (nonatomic, retain) NSMutableArray *colorPaletteList;
@end

@interface OTColorPalette : NSObject
@property (nonatomic, retain) NSMutableArray *paletteColors;
@property (nonatomic) uint8_t uiNameID;
@end

@interface table_S_V_G_ : TTable {
	uint32_t _offsetToSVGDocIndex;
	uint32_t _offsetToColorPalettes;
	uint16_t _numEntries;
}

@property (nonatomic) uint16_t version;
@property (nonatomic, retain) NSMutableArray<OTDocumentIndexEntry *> *entries;
@property (nonatomic, retain) OTColorPalette *colorPalette;
@end
